.LIST
.LISTMAC
.include	"macros.asm"
.include	"def.asm"
; *********************************************************************************************
;	PWM-Testsender fr ATtiny861					 (c) 2024 by DC7GB
; *********************************************************************************************
;
;	Copyright-Vermerk
;	=================
;	Alle Routinen und Include-Dateien (sofern nicht anders angegeben) lizenziert unter:
;	Creative Commons BY-NC-SA 4.0 (https://creativecommons.org/licenses/by-nc-sa/4.0/)
;	
;	Bei Weitergabe, alle nderungen im Code als Kommentar markieren und in main.asm
;	zusammen gefasst in der Versionshistorie beschreiben.
;
;	  !!!!!!!!!
;	!!         !!	Beim Programmieren diese Fuse-Bits berprfen/einstellen: $ff $df $f1
;	!! ACHTUNG !!	Es muss "PLL-Clock" ausgewhlt sein, weil sonst der 64 MHz-Takt nicht
;	!!         !!	erzeugt wird! Der Systemtakt wird dann auf 16MHz erhht!
;	  !!!!!!!!!

;.equ	_SPEEDTEST	= 1	; erzeuge Rechteck am TEST-Ausgang (MP8) PWM wird deaktiviert!
;.equ	_NOPWM		= 1	; moduliere die Pulsbreite nicht mit dem ADC-Signal
;.equ	_RECHTECK	= 1	; erzeuge ein Rechtecksignal zur Bewertung des Mittelwertfilters
.equ	_DM42		= 1	; Berechnung der Sinustabelle mit Taschenrechner


; ***********************************************************************************************
;	Versionshistorie:
; ***********************************************************************************************
;
; V0.9	20240710
; --------------
;     *	basiert auf V0.8 vom 202407xx
;     *	Programm neu aufgebaut, ADC-Interrupt wesentlich vereinfacht und Fehler mit
;	Autotrigger behoben. nderung des Abtasttakts auf Vielfache von 10kHz. Jetzt: 40kHz
;     *	Timer 0 Interrupt bearbeitet den 10ms Flag fr das Hauptprogramm
;
; V0.91	20241114
; --------------
;     *	basiert auf V0.9 vom 20240711
;     *	EEPROM Leseroutinen ergnzt. Die EEOROM-Adresse 0 wird als Parkposition verwendet.
;	Daten beginnen ab Adresse 0x1.
;     *	Das CALBYTE fr den RC-Oszillator wird im EEPROM an Adresse 0x1 abgelegt und kann mit 
;	dem AVR ISP mkII automatisch erzeugt werden. Wird beim Start ein  $ff ausgelesen, so 
;	wird das CALBYTE im Prozessor nicht verndert!
;     *	Triggersignal an PB4 (Pin7) zur Kontrolle der kalibrierten Taktfrequenz von 8 MHz,
;	wenn J3=H. Bei Umschaltung auf den internen Testsinus (J3=L) wird ein Trigger synchron
;	zum erzeugten Testsinus ausgegeben.
;     *	Ansteuerung des FET-Endstufe mit Gegentaktausgang /OC1B und OC1B, sowie mit Dead-Time
;	Generator.
;
; V0.92	20241115
; --------------
;     *	basiert auf V0.91 vom 20241009
;     *	LED blinkt nach dem Anlegen der Versorgungsspannung 3x, um den Start des Controllers
;	anzuzeigen.
;
; V0.93	20241221
; --------------
;     *	basiert auf V0.92 vom 20241215
;     *	Diese Version optimiert die Dead-Time fr den Pegelshifter-Schalter.
;
; V1.0	20250106
; --------------
;     *	basiert auf V0.92 vom 20241221
;     *	Bei freischalten von  _SPEEDTEST  erzeugt der Controller bei richtig eingestellten Fuses
;	(siehe oben) und OSCAL-Byte (siehe data.asm, CALBYTE) ein 2 MHz-Rechtecksignal. Der Bus-
;	Keeper wird dabei deaktiviert, um den Querstrom im Switch auf 0 zu halten.	
;     *	Anpassung der Dead-Time fr den Bus-Keeper/Pegelwandler
;
; V1.1	20250227
; --------------
;     *	basiert auf V1.1 vom 20250106
;     *	Ausgabe eines 1kHz Rechtecks mit m=0,5 mit Schalter _RECHTECK alternativ zum Sinus mglich.


; ***********************************************************************************************
;	Programmstart
; ***********************************************************************************************
.dseg
.org		SRAM_START			; RAM-Anfang setzen


memstart:

.cseg
.org		0

		rjmp	START		; Reset Handler
EXT_INT0:	rjmp	EXT_INT0	; IRQ0 Handler
PCINT:		rjmp	PCINT		; PCINT Handler
TIM1_COMPA:	rjmp	TIM1_COMPA	; Timer1 Compare A Handler
TIM1_COMPB:	rjmp	TIM1_COMPB	; Timer1 Compare B Handler
TIM1_OVF:	rjmp	TIM1_OVF	; Timer1 Overflow Handler
TIM0_OVF:	rjmp	TIM0_OVF	; Timer0 Overflow Handler
USI_START:	rjmp	USI_START	; USI Start Handler
USI_OVF:	rjmp	USI_OVF		; USI Overflow Handler
EE_RDY:		rjmp	EE_RDY		; EEPROM Ready Handler
ANA_COMP:	rjmp	ANA_COMP	; Analog Comparator Handler
		rjmp	ADC_RDY		; ADC Conversion Handler
WDT:		rjmp	WDT		; WDT Interrupt Handler
EXT_INT1:	rjmp	EXT_INT1	; IRQ1 Handler
		rjmp	TIM0_COMPA	; Timer0 Compare A Handler
TIM0_COMPB:	rjmp	TIM0_COMPB	; Timer0 Compare B Handler
TIM0_CAPT:	rjmp	TIM0_CAPT	; Timer0 Capture Event Handler
TIM1_COMPD:	rjmp	TIM1_COMPD	; Timer1 Compare D Handler
FAULT_PROT:	rjmp	FAULT_PROT	; Timer1 Fault Protection


; ----------------------------------------------
; Einsprungpunkt nach RESET

START:		clt				;; Langstart setzen
RESTART:	cli				;; sicherheitshalber alle Interrupt auch manuell sperren
		ldi	temp,low(RAMEND)	;; lower 8 Bit
		out	SPL,temp		;; ...des SP laden
		ldi	temp,high(RAMEND)	;; higher 8 Bit
		out	SPH,temp		;; ...des SP laden

; ----------------------------------------------
; Speicher lschen:

		clr	temp
		ldiw	Z,(memstart)
INIT1:		st	Z+,temp			;; RAM-Zellen ab (memstart) lschen
		cpiw	Z,(RAMEND+1)		;; RAM-Ende erreicht?
		brne	init1			;; nein...
		rcall	init			;; System initialisieren

; ---------------------------------------------
; PowerOn Blinken:

		ldi	counter,5		; Blinkanzahl
BLINKSTART:	ldi	temp,LEDONOFF		; Timer
		sts	t10_start,temp		; ...starten
BLINKLOOPON:	sbi	PORTA,LED		; LED einschalten
		lds	temp,t10_start		; 500ms
		tst	temp			; ...vorbei?
		brne	blinkloopon		; nein...
		ldi	temp,LEDONOFF		; Timer
		sts	t10_start,temp		; ...starten
BLINKLOOPOFF:	cbi	PORTA,LED		; LED ausschalten
		lds	temp,t10_start		; 500ms
		tst	temp			; ...vorbei?
		brne	blinkloopoff		; nein...
		dec	counter			; 3x Blinken vorbei?
		brne	blinkstart


; ***********************************************************************************************
; Beginn des Hauptprogramms
; ***********************************************************************************************
	
WAIT:		sei				; Interrupt frei geben
		sleep				; warte auf Interrupt
		sbrs	flags0,TIMER		; 10ms vorbei?
		rjmp	wait			; nein, warte...
; ----------------------------------------------
		cbr	flags0,(1<<TIMER)	; Timer frei geben
; -------------
; NoPWM-Test:
.ifdef	_NOPWM
		rcall	ledveryfast		; zeige deaktivierten
		rjmp	wait			; ...PWM an
.endif
; -------------
; Sinusausgabe:
		sbic	PINB,J3			; SINUS aktiviert?
		rjmp	main_over		; nein...
		rcall	ledslow			; LED langsam blinken lassen
		rjmp	wait			; Endlosschleife...
; -------------
; Overflowtest:
MAIN_OVER:	sbrs	XH,BIT1			; Wert < 0 ?
		rjmp	main_ovfled		; nein...
		com	XL			; bilde den
		com	XH			; ...Absolutwert
		adiw	X,1			; ...des AD-Samples
		sbrs	XH,BIT0			; absoluten 8Bit-Bereich berschritten?
		rjmp	main_ovfled		; nein...
		ldi	temp,LEDDELAY		; Anzeigeverlngerung
		sts	t10_led,temp		; ...starten
MAIN_OVFLED:	lds	temp,t10_led		; LED schnell
		tst	temp			; ...blinken lassen?
		breq	main_loop		; nein...
		rcall	ledfast			; Overflow anzeigen
		rjmp	wait			; Endlosschleife...
; -------------
; Normalmode:			
MAIN_LOOP:	sbi	PORTA,LED		; LED dauerhaft ein
		rjmp	wait			; Endlosschleife...


; ----------------------------------------------------------------------------------------------

.include	"data.asm"
.include	"init.asm"		
.include	"subroutinen.asm"
.include	"interrupt.asm"
